
;start level
START_LEVEL=1

;(+) ESC - restart
;(+) убрать клики клавиатура
;(+) NTSC\PAL оптимизация
;(+) джойстик
;(+) цвета тайлов менять
;(+) меню
;(+) финал
;(+) gui
;(+) чит кнопки и рестарт

;gameplay states
GS_GAMEPLAY=0
GS_SHOWLEVEL=1
GS_BRIDGE=2
GS_FADEOUT=3
GS_STAGECLEAR=4
GS_DEAD=5

    device ZXSPECTRUM48;it maps pages just 0,1,2,3

    ;Cart mapped in $4000
    org $4000
    include "include\cartHeader.inc" ;include a header that point to Start
    include "include\rom.inc" ;include rom proces names and addrs with discriptions
Start:

    ; init the stack:
    ;ld sp,#F380
    ; reset some interrupts to make sure it runs in some MSX computers 
    ; with disk controllers installed in some interrupt handlers
    di
    ld a,#C9
    ld (HKEY),a
;    ld (TIMI),a
    ei

    call CheckIf60Hz
    call readJoystick1Status
    
    ;32kb ROM fix
    ;set video modes e.t.c        
    call initGame
    call initMenuMusic

    call doMenu



    call initGameplay    
    
mainLoop
;gameLoop:
    halt                  
    ld a,(is60)
    or a
    jr z,66f
    ;skip every 6 frame on NTSC
    ld a,(frames)
    inc a
    cp 6
    jr nz,3f
    xor a : ld (frames),a
    jp playMusic
3:
    ld (frames),a
66:    


    ;jp playMusic
    ;animate fire and gold
    call animateFire
    call animateGold

    ;jp mainLoop

    ld a,(gameState)

    
    cp GS_GAMEPLAY
    jp z,doGameplay

	cp GS_BRIDGE
	jp z,doBridge


    cp GS_SHOWLEVEL
    jp z,doShowLevel

    cp GS_STAGECLEAR
	jp z,doStageClear

	cp GS_DEAD
	jp z,doStageDead  

;    JP mainLoop
playMusic:
        di
		call	PT3_ROUT;write to AY from AY_REGS
		call	PT3_PLAY;play to AY_REGS
        call ayFX_PLAY
        ei
        call readJoystick1Status
        
    jp mainLoop

doStageClear:
	ld a,(deadCount) : dec a : ld (deadCount),a
	or a
	jr z,1f	

	cp 73
	jp nz,playMusic
	ld a,13 : call AFXPLAY3		
	jp playMusic
1:
	ld a,75 : ld (deadCount),a
    ld a,4 : ld (borderColor),a
    ld a,(currentLevel): inc a : ld (currentLevel),a	
	call restartLevel

    jp playMusic

restartLevel:
	 halt	 
	 ;call muteMusic    
	 ld a,GS_SHOWLEVEL : ld (gameState),a		  
    ret

doStageDead:
	ld a,(deadCount) : dec a : ld (deadCount),a
	or a
	jr z,1f	

	cp 73
	jp nz,playMusic
	ld a,14 : call AFXPLAY3		
	jp playMusic
1:
	ld a,75 : ld (deadCount),a
    ld a,6 : ld (borderColor),a
	call restartLevel
    jp playMusic

doDelayedOutro:
	ld a,(outroDelay) : inc a : ld (outroDelay),a
	or a : ret nz
doOutro:	
	ld bc,(outroString)
	push bc
	call drawString
	pop hl : ld bc,29: add hl,bc
	ld a,(hl)
	cp 254
	jr nz,1f
	ld hl,outro4
1:
	ld (outroString),hl
	
	;call playMostSound

	ret


doGameplay:
;	ld	bc,$0c07			; b:=12;c:=7
;	call	WRTVDP				; Set border color 12

    ;copy 32 sprites attributes to VRAM
    ;can low to 4 sprites attributes,actually
    call doSprites  
    ;processHero
    call doHero

    ;do enemies
    call doEnemies  

    ;show outro
    ld a,(currentLevel)
	cp 21
	call z,doDelayedOutro

    ld a,(globalMineDelay)
    inc a : and 1 : ld (globalMineDelay),a
    or a
    jr nz,1f
    ;===================================
    call doKabum
    call doMines
    ;===================================
1:

;		ld	bc,$0107			; b:=1;c:=7
;		call	WRTVDP				; Set border color 1

    ;escape
    ld a,#07
    call SNSMAT 
    bit 2,a
    jp z,2f

    ;R
    ld a,#04    
    call SNSMAT 
    bit 7,a
    jp nz,1f
    bit 6,a
    jr nz,2f
    call muteMusic
    ld a,GS_STAGECLEAR : ld (gameState),a	
    jr 1f
2:
    call muteMusic
    ld a,GS_DEAD : ld (gameState),a    
1: 

    jp playMusic

        

doShowLevel:

    ;init level
    call initLevel   

    ld a,GS_GAMEPLAY : ld (gameState),a
    jp mainLoop

    include "include\engine.asm"
    include "gfx\gfx.asm"
    include "include\level.asm"
    include "maps\maps.a80"
    include "include\unmegalz_fast_v2.asm"
    include "include\hero.asm"
    include "include\bridge.asm"
    include "include\mines.asm"
    include "include\enemy.asm"
    
    ;org 32768    
    ;include sound
   include "include\sound.asm"

   include "gfx\screen.asm"
   include "gfx\menu.asm"
   include "include\menu.asm"
   include "include\strings.asm"

    display /d,"total: ",$-Start

;RAM
    org 49152 ;+8912 for 8k msx
    include "sound\pt3Ram.asm"
    include "sound\ayfxRam.asm"
    ;INCLUDE	"sound\PT3-RAM.ASM"
    include "include\RAM.asm"    

    ;block 99,0
    ;menu is 3400
musicBuffer: block 3400,0

    display /d,"RAM: ",$

	IF (_ERRORS = 0) 
        
            savebin "Yazzie.rom",16384,32768 ;32kb ROM
			SHELLEXEC "Yazzie.rom"

    ENDIF